#include "pch.h"
#include "PDFMenuHelper.h"

using namespace RDPDFLib::view;

PDFMenuHelper::PDFMenuHelper(void)
{
	_initialized = false;
}

void PDFMenuHelper::init(PDF_DOC doc)
{
	m_doc = doc;
	Initialized = true;
}

PDFMenuItem PDFMenuHelper::getMenuRoot()
{
	PDFMenuItem item;
	PDF_OUTLINE resule = Document_getOutlineNext(m_doc, nullptr);
	item.page = Document_getOutlineDest(m_doc, resule);
	wchar_t wLable[256];
	char lable[256];
	Document_getOutlineLabel(m_doc, resule, lable, 256);
	MultiByteToWideChar(0, 0, lable, 256, wLable, 256);
	item.title = ref new String(wLable);
	item.handle = (int)resule;
	return item;
}

PDFMenuItem PDFMenuHelper::getMenuChild(int handle)
{
	PDFMenuItem item;
	PDF_OUTLINE resule = Document_getOutlineChild(m_doc, (PDF_OUTLINE)handle);
	if(!resule)
	{
		item.handle = 0;
	}
	else
	{
		item.page = Document_getOutlineDest(m_doc, resule);
		wchar_t wLable[256];
		char lable[256];
		Document_getOutlineLabel(m_doc, resule, lable, 256);
		MultiByteToWideChar(0, 0, lable, 256, wLable, 256);
		item.title = ref new String(wLable);
		item.handle = (int)resule;
	}
	return item;
}

PDFMenuItem PDFMenuHelper::getMenuNext(int handle)
{
	PDFMenuItem item;
	PDF_OUTLINE resule = Document_getOutlineNext(m_doc, (PDF_OUTLINE)handle);
	if(!resule)
	{
		item.handle = 0;
	}
	else
	{
		item.page = Document_getOutlineDest(m_doc, resule);
		wchar_t wLable[256];
		char lable[256];
		Document_getOutlineLabel(m_doc, resule, lable, 256);
		MultiByteToWideChar(0, 0, lable, 256, wLable, 256);
		item.title = ref new String(wLable);
		item.handle = (int)resule;
	}
	return item;
}
