#pragma once
#include "PDFWinRT.h"
namespace RDPDFLib
{
	namespace view
	{
	public value struct PDFMenuItem
	{
		int page;
		String^ title;
		int handle;
	};

	public ref class PDFMenuHelper sealed
	{
	public:
		PDFMenuHelper(void);
		
		PDFMenuItem getMenuRoot();
		PDFMenuItem getMenuNext(int handle);
		PDFMenuItem getMenuChild(int handle);
		property bool Initialized
		{
			void set(bool value)
			{
				_initialized = value;
			}
			bool get()
			{
				return _initialized;
			}
		}

	internal:
		void init(PDF_DOC doc);
	private:
		PDF_DOC m_doc;
		bool _initialized;
	};
	}
}
