﻿// RadaeePDFRuntime.cpp

#include "pch.h"
#include "RadaeePDFRuntime.h"
using namespace RDPDFLib::view;

static bool g_init = false;

RadaeePDFRuntime::RadaeePDFRuntime()
{
	if( !g_init )
	{
		CPDFVGlobal::Init();
		g_init = true;
	}
	mMenuHelper = nullptr;
}

bool RadaeePDFRuntime::activeLicense( int type, String^ company, String^ mail, String^ serial  )
{
	const wchar_t* wCompany = company->Data();
	int length = company->Length();
	char* cCompany = (char*)malloc((length + 1) * sizeof(char));
	WideCharToMultiByte(0, 0, wCompany, length, cCompany, length, NULL, NULL);
	cCompany[length] = 0;

	const wchar_t* wMail = mail->Data();
	length = mail->Length();
	char* cMail = (char*)malloc((length + 1) * sizeof(char));
	WideCharToMultiByte(0, 0, wMail, length, cMail, length, NULL, NULL);
	cMail[length] = 0;

	const wchar_t* wSerial = serial->Data();
	length = serial->Length();
	char* cSerial = (char*)malloc((length + 1) * sizeof(char));
	WideCharToMultiByte(0, 0, wSerial, length, cSerial, length, NULL, NULL);
	cSerial[length] = 0;

	switch( type )
	{
	case 1:
		return Global_activeProfession( cCompany, cMail, cSerial );
	case 2:
		return Global_activePremium( cCompany, cMail, cSerial );
	default:
		return Global_activeStandard( cCompany, cMail, cSerial );
	}

	free(cCompany);
	free(cMail);
	free(cSerial);
}

void RadaeePDFRuntime::setRenderMode( int mode )
{
	CPDFVGlobal::renderQuality = (PDF_RENDER_MODE)mode;
}

void RadaeePDFRuntime::zoom(bool zoomIn)
{
	if(m_status != sta_zooming && m_status != sta_ink && m_status != sta_rect && m_status != sta_ellipse && m_status != sta_text)
	{
		m_status = sta_zooming;
		m_hold_x = mCanvas->Width/2;
		m_hold_y = mCanvas->Height/2;
		m_zoom_scale = mView->vGetScale();
		mView->vGetPos( m_zoom_pos, m_hold_x, m_hold_y );
		mView->vZoomStart(m_canvas);
		//onDraw(true);
	}
	float scale = 0.9;
	if(zoomIn)
		scale = 1.1;
	m_zoom_scale *= scale;
	mView->vSetScale( m_zoom_scale );
	mView->vSetPos( m_zoom_pos, m_hold_x, m_hold_y );
	onDraw(true);
}

int RadaeePDFRuntime::openPDF(IRandomAccessStream ^stream, String^ password, int mode, SwapChainBackgroundPanel^ SwapChainPanel)
{
	mCanvas = ref new Canvas();
	SwapChainPanel->Children->Append( mCanvas );
	mSearchKeyWord[0] = 0;
	m_status = sta_none;
	switch( mode )
	{
	case 0:
		mView = new CPDFViewVert();
		m_page_mode = false;
		break;
	case 1:
		mView = new CPDFViewHorz(false);
		m_page_mode = false;
		break;
	case 2:
		mView = new CPDFViewHorz(true);
		m_page_mode = false;
		break;
	case 3:
		mView = new CPDFViewDual(false, NULL, 0, NULL, 0);
		m_page_mode = true;
		break;
	case 4:
		mView = new CPDFViewDual(true, NULL, 0, NULL, 0);
		m_page_mode = true;
		break;
	default:
		mView = new CPDFViewVert();
		m_page_mode = false;
		break;
	}
	m_canvas.Initialize( Window::Current->CoreWindow, SwapChainPanel );
	m_canvas.CreateWindowSizeDependentResources();
	mInk = NULL;
	m_press_cnt = 0;
	mIsInAnnotStatus = false;
	mIsDocModified = false;

	mInkColor = 0xFFFF0000;
	mRectColor = 0xFFFF0000;
	mEllipseColor = 0xFFFF0000;

	mInkWidth = 4;
	mRectColor = 4;
	mEllipseWidth = 4;

	m_pts_cnt = 0;

	if(password->Equals(""))
		password = nullptr;
	m_stream = stream;

	//call back function to redraw.
	DispatchedHandler ^render = ref new DispatchedHandler([=](){
		onDraw(false);
	});
	DispatchedHandler ^finder = ref new DispatchedHandler([=](){
		if( mView->vFindGoto() )
			onDraw(false);
		else//no more found, show message
		{
			//mFindEndDialog->show();
		}
	});
	if (m_prev == nullptr)
		m_prev = Window::Current->Content;
	m_pageno = 0;
	Window::Current->Content = SwapChainPanel;
	Window::Current->Activate();
	PDF_ERR err;
	const wchar_t* passwordData = password->Data();
	int length = password->Length();
	char* pwd = (char*)malloc((length + 1) * sizeof(char));
	WideCharToMultiByte(0, 0, passwordData, length, pwd, length, NULL, NULL);
	if( m_doc = Document_open( m_stream, pwd, &err ) )
	{
		/*if(passwordDialog->isShowing())
		{
		passwordDialog->Hide();
		}*/
		mPageCount = Document_getPageCount(m_doc);
		/*PDFPageSlider->Minimum = 1;
		PDFPageSlider->Maximum = mPageCount;*/
		m_canvas.UpdateForWindowSizeChange();
		mView->vOpen( m_doc, 4, 0xFFCCCCCC, SwapChainPanel->Dispatcher, render, finder );
		mView->vResize( m_canvas.GetWidth(), m_canvas.GetHeight() );
		mCanvas->Height = m_canvas.GetHeight();
		mCanvas->Width = m_canvas.GetHeight() * 2;
		int h = m_canvas.GetHeight();
		int w = m_canvas.GetWidth();
		onDraw(false);

		TimeSpan span;
		span.Duration = 35 * 10000;//35 millionseconds.
		auto timerDelegate = [=](ThreadPoolTimer^ timer)
		{
			//call back function to check redraw.
			SwapChainPanel->Dispatcher->RunAsync(Windows::UI::Core::CoreDispatcherPriority::Normal, ref new DispatchedHandler([=]()
			{
				int speedx = get_speed( m_swipe_dx );
				int speedy = get_speed( m_swipe_dy );
				if( speedx || speedy )
				{
					mView->vMoveDelta( speedx, speedy );
					if( mView->vGetX() + m_canvas.GetWidth() >= mView->vGetDocW() && m_swipe_dx > 0 )
						m_swipe_dx = 0;
					else if( mView->vGetX() <= 0 && m_swipe_dx < 0 )
						m_swipe_dx = 0;
					else
						m_swipe_dx -= speedx;
					if( mView->vGetY() + m_canvas.GetHeight() >= mView->vGetDocH() && m_swipe_dy > 0 )
						m_swipe_dy = 0;
					else if( mView->vGetY() <= 0 && m_swipe_dy < 0 )
						m_swipe_dy = 0;
					else
						m_swipe_dy -= speedy;
					onDraw(false);
				}
				else if( mView->vNeedRefresh() ) onDraw(false);
			}));
		};
		//initOptionPanels();
		m_timer = ThreadPoolTimer::CreatePeriodicTimer(ref new TimerElapsedHandler(timerDelegate), span);
	}
	else
	{
		switch (err)
		{
		case PDF_ERR::err_password:
			/*{
			if(passwordDialog->isShowing())
			{
			passwordDialog->showHint();
			}
			else
			passwordDialog->Show();

			return;
			}*/
			break;
		default:
			break;
		}
	}
	return err;
}

void RadaeePDFRuntime::closePDF()
{
	if(mAnnotIndex)
		free(mAnnotIndex);
	if( m_timer )
	{
		m_timer->Cancel();
		m_timer = nullptr;
	}
	if( m_stream )
	{
		delete(m_stream);
		m_stream = nullptr;
		mView->vClose();
		Window::Current->Content = m_prev;
		Window::Current->Activate();
	}
}

void RadaeePDFRuntime::onTouchDown(Windows::UI::Input::PointerPoint^ pt)
{
	insert_point(pt->Position.X, pt->Position.Y, pt->Timestamp);
	mView->vOnTouchDown(pt->Position.X, pt->Position.Y);
}

void RadaeePDFRuntime::onTouchMove(Windows::UI::Input::PointerPoint^ pt)
{
	insert_point(pt->Position.X, pt->Position.Y, pt->Timestamp);
	mView->vOnTouchMove(pt->Position.X, pt->Position.Y);
}

void RadaeePDFRuntime::onMoveEnd(Windows::UI::Input::PointerPoint^ pt, int dx, int dy, bool isMultiPress)
{
	if(m_press_cnt > 0)
		m_press_cnt--;

	mView->vOnTouchMove( pt->Position.X, pt->Position.Y );
	m_status = sta_none;
	if( m_pts_cnt > 3 )
	{
		PDFV_POS pos;
		int cnt = m_pts_cnt;
		long dt = (m_pts[cnt - 1].stamp - m_pts[0].stamp)/1000;
		int dx = m_pts[0].x - m_pts[cnt - 1].x;
		int dy = m_pts[0].y - m_pts[cnt - 1].y;
		if( dt < 400 && dt > 50 )
		{
			m_swipe_dx = (dx * 400) / dt;
			m_swipe_dy = (dy * 400) / dt;
			VPOINT *cur = m_pts;
			VPOINT *end = cur + cnt - 1;
			while( cur < end )
			{
				int dirx = cur[0].x - cur[1].x;
				int diry = cur[0].y - cur[1].y;
				if( (dirx > 0 && dx < 0) ||
					(dirx < 0 && dx > 0) ) m_swipe_dx = 0;
				if( (diry > 0 && dy < 0) ||
					(diry < 0 && dy > 0) ) m_swipe_dy = 0;
				cur++;
			}
			if( m_swipe_dx < 100 && m_swipe_dx > -100 )
				m_swipe_dx = 0;
			if( m_swipe_dy < 100 && m_swipe_dy > -100 )
				m_swipe_dy = 0;
			if( m_page_mode )
			{
				if( m_swipe_dx > 0 )
				{
					mView->vGetPos( pos, m_canvas.GetWidth(), m_canvas.GetHeight() );
					mView->vGetDeltaToCenterPage( pos.pageno, m_swipe_dx, m_swipe_dy );
				}
				else
				{
					mView->vGetPos( pos, 0, 0 );
					mView->vGetDeltaToCenterPage( pos.pageno, m_swipe_dx, m_swipe_dy );
				}
			}
		}
		else if( m_page_mode )
		{
			mView->vGetPos( pos, m_canvas.GetWidth()/2, m_canvas.GetHeight()/2 );
			if( pos.pageno >= 0 )
				mView->vGetDeltaToCenterPage( pos.pageno, m_swipe_dx, m_swipe_dy );
		}
	}
	else if( m_page_mode )
	{
		PDFV_POS pos;
		mView->vGetPos( pos, m_canvas.GetWidth()/2, m_canvas.GetHeight()/2 );
		if( pos.pageno >= 0 )
			mView->vGetDeltaToCenterPage( pos.pageno, m_swipe_dx, m_swipe_dy );
	}
}

void RadaeePDFRuntime::insert_point(float x, float y, long long stamp)
{
	if( m_pts_cnt > 7 )
	{
		m_pts[0] = m_pts[1];
		m_pts[1] = m_pts[2];
		m_pts[2] = m_pts[3];
		m_pts[3] = m_pts[4];
		m_pts[4] = m_pts[5];
		m_pts[5] = m_pts[6];
		m_pts[6] = m_pts[7];
		m_pts[7].x = x;
		m_pts[7].y = y;
		m_pts[7].stamp = stamp;
	}
	else
	{
		m_pts[m_pts_cnt].x = x;
		m_pts[m_pts_cnt].y = y;
		m_pts[m_pts_cnt].stamp = stamp;
		m_pts_cnt++;
	}
}

void RadaeePDFRuntime::onDraw(bool zooming)
{
	mView->vDraw( m_canvas, zooming );
	m_canvas.Present();
}

int RadaeePDFRuntime::find(int dir)
{
	return mView->vFind(dir);
}

void RadaeePDFRuntime::findStart(String^ keyWord, bool matchCase, bool matchWholeWord)
{
	wcscpy_s( mSearchKeyWord, keyWord->Data() );
	mView->vFindStart(mSearchKeyWord, matchCase, matchWholeWord);
}

void RadaeePDFRuntime::findEnd()
{
	mView->vFindEnd();
}

void RadaeePDFRuntime::startInk(unsigned int color, int width)
{
	mInkColor = color;
	mInkWidth = width;
	mInk = Ink_create(mInkWidth, mInkColor);
	m_status = PDF_STATUS::sta_ink;
}

void RadaeePDFRuntime::startRect(unsigned int color, int width)
{
	m_status = PDF_STATUS::sta_rect;
	mRects = NULL;
	mRects_cnt = 0;
	mRects_max = 0;
	mRectColor = color;
	mRectWidth = width;
}

void RadaeePDFRuntime::startEllipse(unsigned int color, int width)
{
	m_status = PDF_STATUS::sta_ellipse;
	mEllipses = NULL;
	mEllipses_cnt = 0;
	mEllipses_max = 0;
	mEllipseColor = color;
	mEllipseWidth = width;
}

void RadaeePDFRuntime::startText()
{
	m_status = PDF_STATUS::sta_text;
}

void RadaeePDFRuntime::onManipulation(Point point, float scale)
{
	if (m_status == sta_zooming && m_zoom_pos.pageno >= 0)
	{
		m_zoom_scale *= scale;
		mView->vSetScale(m_zoom_scale);
		mView->vSetPos(m_zoom_pos, m_hold_x, m_hold_y);
		onDraw(true);
	}
	else
	{
		m_status = sta_zooming;
		m_hold_x = point.X;
		m_hold_y = point.Y;
		m_zoom_scale = mView->vGetScale();
		mView->vGetPos(m_zoom_pos, m_hold_x, m_hold_y);
		mView->vZoomStart(m_canvas);
		onDraw(true);
	}
}

void RadaeePDFRuntime::onManipulationDone()
{
	if( m_status == sta_zooming )
	{
		m_status = sta_none;
		onDraw(false);	}
}

void RadaeePDFRuntime::onSizeChanged()
{
	if(m_status == sta_ink || m_status == sta_rect || m_status == sta_ellipse)
	{
		switch(m_status)
		{
		case sta_ink:
			Ink_onMove( mInk, mLastPoint.X, mLastPoint.Y );
			Ink_onUp( mInk, mLastPoint.X, mLastPoint.Y );
			draw_ink();
			inkEnd(false);
			break;
		case sta_rect:
			mRects[mRects_cnt + 1].x = mLastPoint.X;
			mRects[mRects_cnt + 1].y = mLastPoint.Y;
			draw_rect();
			mRects_cnt += 2;
			rectEnd(false);
			break;
		case sta_ellipse:
			mEllipses[mEllipses_cnt + 1].x = mLastPoint.X;
			mEllipses[mEllipses_cnt + 1].y = mLastPoint.Y;
			draw_ellipse();
			mEllipses_cnt += 2;
			ellipseEnd(false);
			break;
		default:
			break;
		}
		if(m_press_cnt > 0)
			m_press_cnt--;
	}
	m_canvas.UpdateForWindowSizeChange();
	PDFV_POS pos;
	mView->vGetPos(pos,0,0);
	mView->vResize( m_canvas.GetWidth(), m_canvas.GetHeight() );
	mView->vSetScale(0);//缩放比率设置为1
	mView->vSetPos(pos,0,0);

	onDraw(false);
}

void RadaeePDFRuntime::onDown(Point lastPoint, Point point)
{
	m_press_cnt++;

	/*if((m_status == sta_ink || m_status == sta_rect || m_status == sta_ellipse) && m_press_cnt > 1)
	{
	switch (m_status)
	{
	case sta_ink:
	Ink_onMove( mInk, mLastPoint.X, mLastPoint.Y );
	Ink_onUp( mInk, mLastPoint.X, mLastPoint.Y );
	draw_ink();
	break;
	case sta_rect:
	mRects[mRects_cnt + 1].x = mLastPoint.X;
	mRects[mRects_cnt + 1].y = mLastPoint.Y;
	draw_rect();
	mRects_cnt += 2;
	break;
	case sta_ellipse:
	mEllipses[mEllipses_cnt + 1].x = mLastPoint.X;
	mEllipses[mEllipses_cnt + 1].y = mLastPoint.Y;
	draw_ellipse();
	mEllipses_cnt += 2;
	break;
	default:
	break;
	}
	mAnnotControl->ResetLayout();
	mAppBar->IsOpen = true;
	AnnotEnd(false);
	if(m_press_cnt > 0)
	m_press_cnt--;
	return;
	}*/

	if( m_press_cnt != 1 )
	{
		m_status = sta_none;
		return;
	}
	switch (m_status)
	{
	case PDF_STATUS::sta_none:
		m_swipe_dx = 0;
		m_swipe_dy = 0;
		mView->vOnTouchDown( point.X, point.Y );
		m_status = sta_moving;
		m_pts_cnt = 0;
		break;
	case PDF_STATUS::sta_moving:
		//m_pts_cnt = 0;
		break;
	case PDF_STATUS::sta_zooming:
		break;
	case PDF_STATUS::sta_select:
		break;
	case PDF_STATUS::sta_ink:
		if(!mIsInAnnotStatus)
		{
			mIsInAnnotStatus = true;
		}
		if( mInk == NULL)
			mInk = Ink_create( mInkWidth, mInkColor );
		Ink_onDown( mInk, point.X, point.Y );
		mInkPoint = (PDF_POINT *)malloc(sizeof(PDF_POINT ));
		mInkPoint->x = point.X;
		mInkPoint->y = point.Y;
		break;
	case PDF_STATUS::sta_rect:
		if(!mIsInAnnotStatus)
		{
			mIsInAnnotStatus = true;
		}
		if( mRects_cnt >= mRects_max )
		{
			mRects_max += 16;
			mRects = (PDF_POINT *)realloc( mRects, sizeof(PDF_POINT) * mRects_max );
		}
		mRects[mRects_cnt].x = point.X;
		mRects[mRects_cnt].y = point.Y;
		mRects[mRects_cnt + 1].x = point.X;
		mRects[mRects_cnt + 1].y = point.Y;
		break;
	case PDF_STATUS::sta_ellipse:
		if(!mIsInAnnotStatus)
		{
			mIsInAnnotStatus = true;
		}
		if( mEllipses_cnt >= mEllipses_max )
		{
			mEllipses_max += 16;
			mEllipses = (PDF_POINT *)realloc( mEllipses, sizeof(PDF_POINT) * mEllipses_max );
		}
		mEllipses[mEllipses_cnt].x = point.X;
		mEllipses[mEllipses_cnt].y = point.Y;
		mEllipses[mEllipses_cnt + 1].x = point.X;
		mEllipses[mEllipses_cnt + 1].y = point.Y;
		break;
	case PDF_STATUS::sta_text:
		if(!mIsInAnnotStatus)
		{
			mIsInAnnotStatus = true;
		}
		mAnnotPoint = (PDF_POINT*)malloc(sizeof(PDF_POINT));
		mAnnotPoint->x = point.X;
		mAnnotPoint->y = point.Y;
		break;
	default:
		break;
	}
}

void RadaeePDFRuntime::onMove(Point point)
{
	switch(m_status)
	{
	case PDF_STATUS::sta_none:
		break;
	case PDF_STATUS::sta_moving:
		break;
	case PDF_STATUS::sta_zooming:
		break;
	case PDF_STATUS::sta_select:
		break;
	case PDF_STATUS::sta_ink:
		Ink_onMove( mInk, point.X, point.Y );
		draw_ink();
		mLastPoint.X = point.X;
		mLastPoint.Y = point.Y;
		break;
	case PDF_STATUS::sta_rect:
		mRects[mRects_cnt + 1].x = point.X;
		mRects[mRects_cnt + 1].y = point.Y;
		draw_rect();
		mLastPoint.X = point.X;
		mLastPoint.Y = point.Y;
		break;
	case PDF_STATUS::sta_ellipse:
		mEllipses[mEllipses_cnt + 1].x = point.X;
		mEllipses[mEllipses_cnt + 1].y = point.Y;
		draw_ellipse();
		mLastPoint.X = point.X;
		mLastPoint.Y = point.Y;
		break;
	case PDF_STATUS::sta_text:
		break;
	default:
		break;
	}
}

void RadaeePDFRuntime::draw_rect()
{
	mCanvas->Children->Clear();
	Windows::UI::Color clr;
	clr.R = (mRectColor & 0x00FF0000)>>16;
	clr.G = (mRectColor & 0x0000FF00)>>8;
	clr.B = mRectColor & 0x000000FF;
	clr.A = (mRectColor & 0xFF000000)>>24;
	PDF_POINT *cur = mRects;
	PDF_POINT *end = cur + mRects_cnt;
	end += 2;
	while( cur < end )
	{
		Rectangle^ rect = ref new Rectangle();
		rect->Stroke = ref new SolidColorBrush(clr);
		rect->StrokeThickness = mRectWidth;
		rect->StrokeStartLineCap = PenLineCap::Round;
		rect->StrokeLineJoin = PenLineJoin::Round;
		if( cur[1].x > cur->x )
		{
			rect->SetValue(Canvas::LeftProperty, cur->x);
			rect->Width = cur[1].x - cur->x;
		}
		else
		{
			rect->SetValue(Canvas::LeftProperty, cur[1].x);
			rect->Width = cur->x - cur[1].x;
		}
		if( cur[1].y > cur->y )
		{
			rect->SetValue(Canvas::TopProperty, cur->y);
			rect->Height = cur[1].y - cur->y;
		}
		else
		{
			rect->SetValue(Canvas::TopProperty, cur[1].y);
			rect->Height = cur->y - cur[1].y;
		}
		mCanvas->Children->Append(rect);
		cur += 2;
	}
}

void RadaeePDFRuntime::draw_ink()
{
	mCanvas->Children->Clear();
	int cur = 0;
	int end = Ink_getNodeCount( mInk );
	if( end < 2 ) return;
	Path ^ink = ref new Path();
	Windows::UI::Color clr;

	clr.R = (mInkColor & 0x00FF0000)>>16;
	clr.G = (mInkColor & 0x0000FF00)>>8;
	clr.B = mInkColor & 0x000000FF;
	clr.A = (mInkColor & 0xFF000000)>>24;
	ink->Stroke = ref new SolidColorBrush(clr);
	ink->StrokeThickness = mInkWidth;
	ink->StrokeStartLineCap = PenLineCap::Round;
	ink->StrokeLineJoin = PenLineJoin::Round;
	PathGeometry ^inkg = ref new PathGeometry();
	PathFigure ^inkf = nullptr;
	PDF_POINT pt_prev;
	PDF_POINT pt;
	Point ppt;
	LineSegment ^line;
	Windows::UI::Xaml::Media::BezierSegment ^bezier;
	for( cur = 0; cur < end; cur++ )
	{
		switch( Ink_getNode( mInk, cur, &pt ) )
		{
		case 1:
			line = ref new LineSegment();
			ppt.X = pt.x;
			ppt.Y = pt.y;
			line->Point = ppt;
			inkf->Segments->Append( line );
			break;
		case 2:
			bezier = ref new Windows::UI::Xaml::Media::BezierSegment();
			ppt.X = pt.x;
			ppt.Y = pt.y;
			bezier->Point1 = ppt;
			bezier->Point2 = ppt;
			Ink_getNode( mInk, cur + 1, &pt );
			ppt.X = pt.x;
			ppt.Y = pt.y;
			bezier->Point3 = ppt;
			cur++;
			inkf->Segments->Append( bezier );
			break;
		default:
			if( inkf != nullptr )
				inkg->Figures->Append( inkf );
			inkf = ref new PathFigure();
			ppt.X = pt.x;
			ppt.Y = pt.y;
			inkf->StartPoint = ppt;
			pt_prev = pt;
			break;
		}
	}
	if( inkf != nullptr )
		inkg->Figures->Append( inkf );
	ink->Data = inkg;
	mCanvas->Children->Append(ink);
}

void RadaeePDFRuntime::draw_ellipse()
{
	mCanvas->Children->Clear();
	Windows::UI::Color clr;
	clr.R = (mEllipseColor & 0x00FF0000)>>16;
	clr.G = (mEllipseColor & 0x0000FF00)>>8;
	clr.B = mEllipseColor & 0x000000FF;
	clr.A = (mEllipseColor & 0xFF000000)>>24;
	PDF_POINT *cur = mEllipses;
	PDF_POINT *end = cur + mEllipses_cnt;
	end += 2;
	while( cur < end )
	{
		Windows::UI::Xaml::Shapes::Ellipse^ ellipse = ref new Windows::UI::Xaml::Shapes::Ellipse();
		ellipse->Stroke = ref new SolidColorBrush(clr);
		ellipse->StrokeThickness = mEllipseWidth;
		ellipse->StrokeStartLineCap = PenLineCap::Round;
		ellipse->StrokeLineJoin = PenLineJoin::Round;
		if( cur[1].x > cur->x )
		{
			ellipse->SetValue(Canvas::LeftProperty, cur->x);
			ellipse->Width = cur[1].x - cur->x;
		}
		else
		{
			ellipse->SetValue(Canvas::LeftProperty, cur[1].x);
			ellipse->Width = cur->x - cur[1].x;
		}
		if( cur[1].y > cur->y )
		{
			ellipse->SetValue(Canvas::TopProperty, cur->y);
			ellipse->Height = cur[1].y - cur->y;
		}
		else
		{
			ellipse->SetValue(Canvas::TopProperty, cur[1].y);
			ellipse->Height = cur->y - cur[1].y;
		}
		mCanvas->Children->Append(ellipse);
		cur += 2;
	}
}

void RadaeePDFRuntime::onUp(Point point)
{
	if(m_press_cnt > 0)
		m_press_cnt--;

	switch(m_status)
	{
	case PDF_STATUS::sta_none:
		break;
	case PDF_STATUS::sta_moving:
		break;
	case PDF_STATUS::sta_zooming:
		break;
	case PDF_STATUS::sta_select:
		break;
	case PDF_STATUS::sta_ink:
		if(!mIsInAnnotStatus)
		{
			return;
		}
		Ink_onUp(mInk, point.X, point.Y);
		draw_ink();
		mIsInAnnotStatus = false;
		break;
	case PDF_STATUS::sta_rect:
		if(!mIsInAnnotStatus)
		{
			return;
		}
		mRects[mRects_cnt + 1].x = point.X;
		mRects[mRects_cnt + 1].y = point.Y;
		draw_rect();
		mRects_cnt += 2;
		mIsInAnnotStatus = false;
		break;
	case PDF_STATUS::sta_ellipse:
		if(!mIsInAnnotStatus)
		{
			return;
		}
		//mAppBar->IsOpen = true;
		mEllipses[mEllipses_cnt + 1].x = point.X;
		mEllipses[mEllipses_cnt + 1].y = point.Y;
		draw_ellipse();
		mEllipses_cnt += 2;
		mIsInAnnotStatus = false;
		break;
	case PDF_STATUS::sta_text:
		break;
	default:
		break;
	}

}

void RadaeePDFRuntime::inkEnd(bool cancel)
{
	if (!cancel && mInk)
	{
		PDF_POINT pt;
		Ink_getNode(mInk, 0, &pt);//the first pressed point
		PDFV_POS pos;
		mView->vGetPos(pos, pt.x, pt.y);
		CPDFVPage* vpage = mView->vGetPage(pos.pageno);//get page object from point
		PDF_PAGE page = vpage->GetPage();
		if (page)
		{
			PDF_MATRIX matrix = vpage->CreateMatrix();
			Page_addAnnotInk(page, matrix, mInk, -vpage->GetVX(mView->vGetX()), -vpage->GetVY(mView->vGetY()));
			Matrix_destroy(matrix);
			free(mInkPoint);
			mIsDocModified = true;
		}
		mView->vRenderPage(pos.pageno);
	}
	Ink_destroy(mInk);
	mInk = NULL;
	mCanvas->Children->Clear();
	m_status = PDF_STATUS::sta_none;
}

void RadaeePDFRuntime::rectEnd(bool cancel)
{
	if(m_status == sta_rect && !cancel)
	{
		int cur;
		for(cur = 0; cur < mRects_cnt; cur += 2)
		{
			PDFV_POS pos;
			mView->vGetPos(pos, mRects[cur].x, mRects[cur].y);
			CPDFVPage* vPage = mView->vGetPage(pos.pageno);
			PDF_PAGE page = vPage->GetPage();
			if(page)
			{
				PDF_MATRIX matrix = vPage->CreateMatrix();
				PDF_RECT rect;
				if(mRects[cur].x > mRects[cur + 1].x)
				{
					rect.left = mRects[cur+1].x - vPage->GetVX(mView->vGetX());
					rect.right = mRects[cur].x - vPage->GetVX(mView->vGetX());
				}
				else
				{
					rect.left = mRects[cur].x - vPage->GetVX(mView->vGetX());
					rect.right = mRects[cur+1].x - vPage->GetVX(mView->vGetX());
				}
				if(mRects[cur].y > mRects[cur + 1].y)
				{
					rect.top = mRects[cur + 1].y - vPage->GetVY(mView->vGetY());
					rect.bottom = mRects[cur].y - vPage->GetVY(mView->vGetY());

				}
				else
				{
					rect.top = mRects[cur].y - vPage->GetVY(mView->vGetY());
					rect.bottom = mRects[cur + 1].y - vPage->GetVY(mView->vGetY());
				}
				Page_addAnnotRect(page, matrix, &rect, mRectWidth, mRectColor, NULL);
				mIsDocModified = true;
				Matrix_destroy(matrix);
				mView->vRenderPage(pos.pageno);
			}
		}
	}
	mRects_cnt = 0;
	mRects_max = 0;
	free(mRects);
	mCanvas->Children->Clear();
	m_status = PDF_STATUS::sta_none;
}

void RadaeePDFRuntime::ellipseEnd(bool cancel)
{
	if(m_status == sta_ellipse && !cancel)
	{
		int cur;
		for(cur = 0; cur < mEllipses_cnt; cur += 2)
		{
			PDFV_POS pos;
			mView->vGetPos(pos, mEllipses[cur].x, mEllipses[cur].y);
			CPDFVPage* vPage = mView->vGetPage(pos.pageno);
			PDF_PAGE page = vPage->GetPage();
			if(page)
			{
				PDF_MATRIX matrix = vPage->CreateMatrix();
				PDF_RECT rect;
				if(mEllipses[cur].x > mEllipses[cur + 1].x)
				{
					rect.left = mEllipses[cur+1].x - vPage->GetVX(mView->vGetX());
					rect.right = mEllipses[cur].x - vPage->GetVX(mView->vGetX());
				}
				else
				{
					rect.left = mEllipses[cur].x - vPage->GetVX(mView->vGetX());
					rect.right = mEllipses[cur+1].x - vPage->GetVX(mView->vGetX());
				}
				if(mEllipses[cur].y > mEllipses[cur + 1].y)
				{
					rect.top = mEllipses[cur + 1].y - vPage->GetVY(mView->vGetY());
					rect.bottom = mEllipses[cur].y - vPage->GetVY(mView->vGetY());

				}
				else
				{
					rect.top = mEllipses[cur].y - vPage->GetVY(mView->vGetY());
					rect.bottom = mEllipses[cur + 1].y - vPage->GetVY(mView->vGetY());
				}
				Page_addAnnotEllipse(page, matrix, &rect, mEllipseWidth, mEllipseColor, NULL);
				mIsDocModified = true;
				Matrix_destroy(matrix);
				mView->vRenderPage(pos.pageno);
			}
		}
	}
	mRects_cnt = 0;
	mRects_max = 0;
	free(mEllipses);
	mCanvas->Children->Clear();
	m_status = PDF_STATUS::sta_none;
}

void RadaeePDFRuntime::textEnd(bool cancel)
{
	if(m_status == sta_text && cancel)
	{
		//TODO: remove all added text annotation
		mAnnotCount -= 1;
		int annotPage[8];
		int currentPageIndex = 0;
		while(mAnnotCount >= 0)
		{
			CPDFVPage* vpage = mView->vGetPage(mAnnotIndex[mAnnotCount].page);//get page object from point
			if(vpage)
			{
				PDF_PAGE page = vpage->GetPage();
				if(page)
				{
					PDF_ANNOT annot = Page_getAnnot(page, mAnnotIndex[mAnnotCount].annotIndex);
					if(annot)
					{
						Page_removeAnnot(page , annot);
					}
					for(int i = 0; i < 8; i++)
					{
						if(annotPage[i] == mAnnotIndex[mAnnotCount].page)
							break;
						annotPage[currentPageIndex] =  mAnnotIndex[mAnnotCount].page;
						currentPageIndex++;
					}
					mAnnotCount--;
				}
			}
		}
		for(int i = 0; i <= currentPageIndex; i++)
			mView->vRenderPage(annotPage[i]);
	}
	try{
		free(mAnnotIndex);
		mAnnotIndex = nullptr;
	}
	catch (Exception^ e)
	{
	}

	mAnnotCount = 0;
	mMaxAnnotCount = 8;
	m_status = PDF_STATUS::sta_none;
}

PDFAnnot RadaeePDFRuntime::getAnnotFromPoint(Point point)
{
	PDFAnnot annot;
	annot.title = "";
	annot.content = "";
	mAnnotPoint = (PDF_POINT*)malloc(sizeof(PDF_POINT));
	mAnnotPoint->x = point.X;
	mAnnotPoint->y = point.Y;
	PDFV_POS pos;
	mView->vGetPos(pos, mAnnotPoint->x, mAnnotPoint->y);
	CPDFVPage* vPage = mView->vGetPage(pos.pageno);
	if(!vPage) return annot;
	PDF_PAGE page = vPage->GetPage();
	if(!page) return annot;
	PDF_ANNOT pdfAnnot = Page_getAnnotFromPoint(page, pos.x, pos.y);
	if(pdfAnnot)
	{
		char subj[256] = {0};
		char text[256] = {0};
		wchar_t wSubj[256];
		wchar_t wText[256];
		Page_getAnnotPopupSubject( page, pdfAnnot, subj, 256 );
		Page_getAnnotPopupText( page, pdfAnnot, text, 256 );
		MultiByteToWideChar(0, 0, subj, 256, wSubj, 256);
		MultiByteToWideChar(0, 0, text, 256, wText, 256);
		String^ subject = ref new String(wSubj);
		String^ content = ref new String(wText);
		annot.title = subject;
		annot.content = content;
	}
	return annot;
}

void RadaeePDFRuntime::onCloseTextAnnot(String^ subject, String^ content, bool cancel, bool edit)
{
	if(mAnnotPoint == NULL) return;
	if(cancel)
	{
		if(m_press_cnt > 0)
			m_press_cnt--;
		free(mAnnotPoint);
		return;
	}
	PDFV_POS pos;
	mView->vGetPos(pos, mAnnotPoint->x, mAnnotPoint->y);
	CPDFVPage* vPage = mView->vGetPage(pos.pageno);

	if(vPage)
	{
		PDF_PAGE page = vPage->GetPage();
		if(!page) return;
		PDF_ANNOT annot;
		if(!edit)
		{
			PDF_MATRIX matrix = vPage->CreateMatrix();
			Page_addAnnotText(page, matrix,  vPage->ToDIBX(pos.x), vPage->ToDIBY(pos.y));
			int count = Page_getAnnotCount(page);
			Matrix_destroy(matrix);
			if (count <= 0)
				return;
			annot = Page_getAnnot(page, count - 1);
		}
		else
			annot = Page_getAnnotFromPoint(page, pos.x, pos.y);
		if(!annot) return;
		const wchar_t* subjectData = subject->Data();
		int length = subject->Length();
		char* subj = (char*)malloc((length + 1) * sizeof(char));
		WideCharToMultiByte(0, 0, subjectData, length, subj, length, NULL, NULL);
		subj[length] = 0;
		Page_setAnnotPopupSubject(page, annot, subj );

		const wchar_t* contentData = content->Data();
		length = content->Length();
		char* cont = (char*)malloc((length + 1) * sizeof(char));
		WideCharToMultiByte(0, 0, contentData, length, cont, length, NULL, NULL);
		cont[length] = 0;
		Page_setAnnotPopupText(page, annot, cont );
		free(mAnnotPoint);
		mAnnotPoint = NULL;
		if(!mAnnotIndex)
		{
			mAnnotIndex = (textAnnot*)malloc(sizeof(textAnnot) * mMaxAnnotCount);
		}
		else if(mAnnotCount == mMaxAnnotCount)
		{
			mMaxAnnotCount += 8;
			mAnnotIndex = (textAnnot*)realloc(mAnnotIndex, sizeof(textAnnot) * mMaxAnnotCount);
		}
		mAnnotIndex[mAnnotCount].annotIndex = Page_getAnnotCount(page) - 1;
		mAnnotIndex[mAnnotCount].page = pos.pageno;
		mAnnotCount += 1;

		mView->vRenderPage(pos.pageno);
	}
	if(m_press_cnt > 0)
		m_press_cnt--;
}

void RadaeePDFRuntime::saveDocument()
{
	Document_save(m_doc);
}

PDFMenuHelper^ RadaeePDFRuntime::getMenuHelper()
{
	if(mMenuHelper == nullptr)
	{
		mMenuHelper = ref new PDFMenuHelper();
	}
	if(!mMenuHelper->Initialized)
	{
		mMenuHelper->init(m_doc);
	}
	return mMenuHelper;
}

int RadaeePDFRuntime::getPageCount()
{
	return Document_getPageCount(m_doc);
}

int RadaeePDFRuntime::getCurrentPage()
{
	PDFV_POS pos;
	mView->vGetPos(pos, 0, 0);
	return pos.pageno;
}

void RadaeePDFRuntime::gotoPage(int page)
{
	PDFV_POS pos;
	pos.pageno = page;
	pos.x = 0;
	pos.y = Document_getPageHeight(m_doc, page);
	mView->vSetPos(pos, 0, 0);
	mView->vRenderPage(pos.pageno);
}