﻿#pragma once

#include "PDFView/PDFView.h"
#include "PDFView/PDFVGlobal.h"
#include "PDFMenuHelper.h"

using namespace Windows::UI::Xaml;
using namespace Windows::UI::Core;
using namespace Platform;
using namespace Windows::UI::Xaml::Controls;
using namespace Windows::UI::Xaml::Shapes;
using namespace Windows::UI::Xaml::Media;
//using namespace RadaeeRuntimeComponent;

namespace RDPDFLib
{
	namespace view
	{
	public value struct PDFAnnot
	{
		String^ title;
		String^ content;
	};

	public ref class RadaeePDFRuntime sealed
	{
	public:
		RadaeePDFRuntime();
		static bool activeLicense( int type, String^ company, String^ mail, String^ serial  );
		static void setRenderMode( int mode );
		int openPDF(IRandomAccessStream ^stream, String^ password, int mode, SwapChainBackgroundPanel^ SwapChainPanel);
		void closePDF();
		void onTouchDown(Windows::UI::Input::PointerPoint^ pt);
		void onTouchMove(Windows::UI::Input::PointerPoint^ pt);
		void onMoveEnd(Windows::UI::Input::PointerPoint^ pt, int dx, int dy, bool isMultiPress);
		void onDraw(bool zooming);
		void findStart(String^ keyWrod, bool matchCase, bool matchWholeWord);
		void findEnd();
		int find(int dir);

		void startInk(unsigned int color, int width);
		void startRect(unsigned int color, int width);
		void startEllipse(unsigned int color, int width);
		void startText();
		void onMove(Point point);
		void onUp(Point point);
		void onDown(Point lastPoint, Point point);
		void inkEnd(bool cancel);
		void rectEnd(bool cancel);
		void ellipseEnd(bool cancel);
		void textEnd(bool cancel);
		void onManipulation(Point point, float scale);
		void onManipulationDone();
		void onSizeChanged();

		PDFAnnot getAnnotFromPoint(Point point);
		void onCloseTextAnnot(String^ subject, String^ content, bool cancel, bool edit);
		void saveDocument();

		void zoom(bool zoomIn);

		PDFMenuHelper^ getMenuHelper();

		int getPageCount();
		int getCurrentPage();

		void gotoPage(int page);

	private:
		static inline int get_speed(int delta)
		{
			if( delta > 0 )
			{
				if( delta < 3 ) return delta;
				return sqrt( delta << 2 );
			}
			else
			{
				if( delta > -3 ) return delta;
				return -sqrt( (-delta) << 2 );
			}
		}

		enum PDF_STATUS
		{
			sta_none = 0,
			sta_moving = 1,
			sta_zooming = 2,
			sta_select = 3,
			sta_ink = 4,
			sta_rect = 5,
			sta_ellipse = 6,
			sta_text = 7,
		}m_status;

		void draw_ink();
		void draw_rect();
		void draw_ellipse();

		UIElement ^m_prev;
		PDF_DOC m_doc;
		CPDFView* mView;
		IRandomAccessStream^ m_stream;
		CPDFVCanvas m_canvas;
		Canvas^ mCanvas;
		ThreadPoolTimer^ m_timer;
		int m_swipe_dx;
		int m_swipe_dy;
		int mPageCount;
		int m_pageno;
		bool m_page_mode;
		struct textAnnot
		{
			int annotIndex;
			int page;
		};
		textAnnot* mAnnotIndex;
		wchar_t mSearchKeyWord[256];


		struct VPOINT
		{
			float x;
			float y;
			long long stamp;
		}m_pts[8];

		int m_press_cnt;
		int m_pts_cnt;
		bool mIsInAnnotStatus;
		bool mIsDocModified;

		PDF_INK mInk;
		PDF_POINT* mInkPoint;
		int mInkColor;
		int mInkWidth;

		PDF_POINT* mRects;
		int mRects_cnt;
		int mRects_max;
		int mRectColor;
		int mRectWidth;

		PDF_POINT* mEllipses;
		int mEllipses_cnt;
		int mEllipses_max;
		int mEllipseColor;
		int mEllipseWidth;

		PDF_POINT* mAnnotPoint;
		int mMaxAnnotCount;
		int mAnnotCount;

		PDFV_POS m_zoom_pos;
		float m_zoom_scale;
		float m_hold_x;
		float m_hold_y;

		Point mLastPoint;

		PDFMenuHelper^ mMenuHelper;

		void insert_point(float x, float y, long long stamp);
	};
	}
}